<?php
namespace App\Hooks\Addons;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Request;
use App\Helpers\Logger;
use App\Models\ClientSettings;

class SlackMessage
{
    public function onDnsServerIsUp($server)
    {     
        $message = 'Your Dns Server is back up now. Name: '.$server->website_domain  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($server->user_id, $message);
    }
    public function onDnsServerIsDown($server)
    {     
        $message = 'Your Dns Server is down. Name: '.$server->website_domain  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($server->user_id, $message);
    }
    public function onServerIsUp($server)
    {     
        $message = 'Your Server is back up now. Name: '.$server->name  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($server->user_id, $message);
    }
    public function onServerIsDown($server)
    {     
        $message = 'Your Server is down. Name: '.$server->name  ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($server->user_id, $message);
    }
    public function onWebpageIsUp($webpage)
    {     
        $message = 'Your Webpage is back up now. Name: '.$webpage->name ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($webpage->user_id, $message);
    }
    public function onWebpageIsDown($webpage)
    {     
        $message = 'Your Webpage is down. Name: '.$webpage->name  ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($webpage->user_id, $message);
    }
    public function onApiIsUp($api)
    {     
        $message = 'Your API is back up now. Name: '.$api->name ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($api->user_id, $message);
    }
    public function onApiIsDown($api)
    {     
        $message = 'Your API is down. Name: '.$api->name  ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($api->user_id, $message);
    }
    public function onKeywordIsUp($keyword)
    {     
        $message = 'Your Keyword is back up now. Name: '.$keyword->name ;
        // TO Do: Language file changes 
        $this->sendSlackMessage($keyword->user_id, $message);
    }
    public function onKeywordIsDown($keyword)
    {     
        $message = 'Your Keyword is down. Name: '.$keyword->name  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($keyword->user_id, $message);
    }
    public function onSslExpiry($ssl, $expireIn)
    {
        $message = 'Your SSL  validity for '.$ssl->name.' will expire in '.$expireIn.' days.'  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($ssl->user_id, $message);
    }
    public function onDomainExpiry($domain, $expireIn)
    {
        $message = 'Your Domain  validity for '.$domain->name.' will expire in '.$expireIn.' days.'  ;
        // TO Do: Language file changes
        $this->sendSlackMessage($domain->user_id, $message);
    }
    public function onPlanExpired($user)
    {
        $message = 'Your Server Monitor by Modules Panel Plan has expired';
        // TO Do: Language file changes
        $this->sendSlackMessage($user->id, $message);
    }
    public function onPlanExpiry($user,$expireIn)
    {
        $message = 'Your Server Monitor by Modules Panel Plan will expire in '.$expireIn.' days';
        // TO Do: Language file changes
        $this->sendSlackMessage($user->id, $message);
    }
    public function sendSlackMessage($id, $message)
    {
        try{
            $token = ClientSettings::where('user_id',$id)->where('key','slack_token')->first();
            $channel = ClientSettings::where('user_id',$id)->where('key','slack_channel')->first();
            Logger::info($channel->value);
            //$slack = new wrapi\slack\slack($token);
            if($token !== null && $channel !== null){
              $slack_token = $token->value;
              Logger::info($slack_token);
              $slack = new \wrapi\slack\slack($slack_token);
              $test = $slack->chat->postMessage(array(
                  "channel" => $channel->value,
                  "text" => $message
                )
              );
            }
            
        }
        catch(\Exception $e){
            Logger::error($e->getMessage());
            
       }
        
        
    }
  }