<?php
namespace App\Hooks\Addons;
use Illuminate\Support\Facades\Schema;
use Illuminate\Http\Request;
use Twilio\Rest\Client;
use App\Models\Addons\AddonSettings;
use App\Helpers\Logger;
use App\Models\ClientSettings;

class TwilioSms
{
    public function onDnsServerIsUp($server)
    {     
        $message = 'Your Dns Server is back up now. Name: '.$server->website_domain  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($server->user_id, $message);
    }
    public function onDnsServerIsDown($server)
    {     
        $message = 'Your Dns Server is down. Name: '.$server->website_domain  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($server->user_id, $message);
    }
    public function onServerIsUp($server)
    {     
        $message = 'Your Server is back up now. Name: '.$server->name  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($server->user_id, $message);
    }
    public function onServerIsDown($server)
    {     
        $message = 'Your Server is down. Name: '.$server->name  ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($server->user_id, $message);
    }
    public function onWebpageIsUp($webpage)
    {     
        $message = 'Your Webpage is back up now. Name: '.$webpage->name ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($webpage->user_id, $message);
    }
    public function onWebpageIsDown($webpage)
    {     
        $message = 'Your Webpage is down. Name: '.$webpage->name  ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($webpage->user_id, $message);
    }
    public function onApiIsUp($api)
    {     
        $message = 'Your API is back up now. Name: '.$api->name ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($api->user_id, $message);
    }
    public function onApiIsDown($api)
    {     
        $message = 'Your API is down. Name: '.$api->name  ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($api->user_id, $message);
    }
    public function onKeywordIsUp($keyword)
    {     
        $message = 'Your Keyword is back up now. Name: '.$keyword->name ;
        // TO Do: Language file changes 
        $this->getRecipientNumber($keyword->user_id, $message);
    }
    public function onKeywordIsDown($keyword)
    {     
        $message = 'Your Keyword is down. Name: '.$keyword->name  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($keyword->user_id, $message);
    }
    public function onSslExpiry($ssl, $expireIn)
    {
        $message = 'Your SSL  validity for '.$ssl->name.' will expire in '.$expireIn.' days.'  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($ssl->user_id, $message);
    }
    public function onDomainExpiry($domain, $expireIn)
    {
        $message = 'Your Domain  validity for '.$domain->name.' will expire in '.$expireIn.' days.'  ;
        // TO Do: Language file changes
        $this->getRecipientNumber($domain->user_id, $message);
    }
    public function onPlanExpired($user)
    {
        $message = 'Your Server Monitor by Modules Panel Plan has expired';
        // TO Do: Language file changes
        $this->getRecipientNumber($user->id, $message);
    }
    public function onPlanExpiry($user,$expireIn)
    {
        $message = 'Your Server Monitor by Modules Panel Plan will expire in '.$expireIn.' days';
        // TO Do: Language file changes
        $this->getRecipientNumber($user->id, $message);
    }
    public function getRecipientNumber($id, $message)
    {
        try{
            $recipient = ClientSettings::where('user_id',$id)->where('key','alert_sms_numbers')->first();
            Logger::info($recipient);
            $smsNumbers = $recipient->value;
            if($smsNumbers) {
                $numbers = explode( ',', $smsNumbers);
                Logger::info($numbers);
                foreach ($numbers as $number) {
                    Logger::info($number);
                    $this->sendMessage($message, trim($number));
                }
            }
            // else
            // Logger::error('Please Add Number');
        }
        catch(\Exception $e){
            Logger::error($e->getMessage());
            
       }
        
        
    }
    /**
     * Sends sms to user using Twilio's programmable sms client
     * @param String $message Body of sms
     */
    private function sendMessage($message, $recipient)
    {
        try{
            $twilioSettings = AddonSettings::where('addon_name','Twilio SMS')->get();
            foreach($twilioSettings as $settings){
                if($settings->key == 'sid')
                    $sid = $settings->value;
                elseif($settings->key == 'auth_token')
                    $token = $settings->value;
                elseif($settings->key == 'number')
                    $number = $settings->value;
            }
            $client = new Client($sid, $token);
            $client->messages->create($recipient, array('from' => $number, 'body' => $message));
            Logger::info("Sms sent.");
        }
       catch(\Exception $e){
            Logger::error($e->getMessage());
            
       }
    }
    
    
}
