<?php

namespace App\Http\Controllers\Addons;
use App\Http\Controllers\Controller;
use App\Models\Addons\AddonSettings;
use Illuminate\Support\Facades\Validator;
use App\Helpers\Logger;
use App\Helpers\Uuid;

use Illuminate\Http\Request;

class TwilioSmsController extends Controller
{
    public function __construct()
    {
        /*
         * make sure only logged in and verified admin has access

         */
        $this->middleware(['auth', 'verified']);
    }

    public function createSettings()
    {
        $addonSettings = AddonSettings::where('addon_name','Twilio SMS')->get();
        $settings = [];
        foreach($addonSettings as $addsetting){
            $settings[$addsetting->key]=$addsetting->value ;
        }
        $params = [
            'settings' => $settings,
        ];
        return view('addon/twilio_settings',$params);
    }

    public function storeSettings(Request $request)
    {
        
        try {
            // Form validation
            $validator = Validator::make($request->all(), [
                'sid' => 'required',
                'token' => 'required',
                'number' => 'required'
            ]);
            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->withInput()
                    ->withErrors($validator);
            }
            
            $updateSettings = AddonSettings::where('addon_name','Twilio SMS')->get();
            //Update the settings if  already exist
            if (count($updateSettings)>0) {
                foreach($updateSettings as $update){
                    //dd($update);
                    if($update->key == 'sid')
                        $update->value = $request->sid;
                    elseif($update->key == 'auth_token')
                        $update->value = $request->token;
                    elseif($update->key == 'number')
                        $update->value = $request->number;

                    $update->save();
                }
                
            } else {
                //create new 
                $settings1 = new AddonSettings();
                $settings1->uuid = Uuid::getUuid();
                $settings1->addon_name = 'Twilio SMS';
                $settings1->key = 'sid';
                $settings1->value = $request->sid;
                $settings1->save();

                $settings2 = new AddonSettings();
                $settings2->uuid = Uuid::getUuid();
                $settings2->addon_name = 'Twilio SMS';
                $settings2->key = 'auth_token';
                $settings2->value = $request->token;
                $settings2->save(); 
                
                $settings3 = new AddonSettings();
                $settings3->uuid = Uuid::getUuid();
                $settings3->addon_name = 'Twilio SMS';
                $settings3->key = 'number';
                $settings3->value = $request->number;
                $settings3->save();
            }

            return redirect()->route('addon.index')
                ->with('success', __('Twilio Credentials Updated'));
        } catch (\Exception $e) {
            Logger::error($e->getMessage());
            return redirect()
                ->back()
                ->withInput()
                ->with('error', __($e->getMessage()));
        }
        
    }

}
