<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\Localization;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/lang/{locale}', function($locale){
    session()->put('locale', $locale);
    //dd($locale);
   // App::setlocale($locale);
    return redirect()->back();
});

Auth::routes(['verify' => true]);

// Route::get('/', [App\Http\Controllers\DashboardController::class, 'index']);



Route::match(['get', 'post'],'/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');



Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');
// TicketStatusController CRUD
Route::resource('ticket_status', App\Http\Controllers\TicketStatusController::class);
Route::resource('roles', App\Http\Controllers\RoleController::class);
Route::get('role_permission-detail/{role_id}/permission',[App\Http\Controllers\RolePermissionController::class,'rolePermission'])->name('role_permission.detail');
Route::get('role_permission-detail/{role_id}/selectall',[App\Http\Controllers\RolePermissionController::class,'selectAll'])->name('role_permission.select');
Route::get('roles/permission', [App\Http\Controllers\RoleController::class, 'permissions'])->name('roles.permission');
Route::resource('role_permission', App\Http\Controllers\RolePermissionController::class);
Route::resource('department', App\Http\Controllers\DepartmentController::class);
Route::resource('product', App\Http\Controllers\ProductController::class);
Route::resource('announcement', App\Http\Controllers\AnnouncementController::class);
Route::match(['get', 'post'], '/products', [App\Http\Controllers\ProductController::class, 'index'])->name('products');
Route::match(['get', 'post'], '/get_announcement', [App\Http\Controllers\AnnouncementController::class, 'index'])->name('get_announcement');
Route::match(['get', 'post'], '/user_announcements', [App\Http\Controllers\AnnouncementController::class, 'userAnnouncement'])->name('user_announcements');
Route::match(['get', 'post'], '/get_roles', [App\Http\Controllers\RoleController::class, 'index'])->name('get_roles');
Route::match(['get', 'post'], '/get_ticket_statuses', [App\Http\Controllers\TicketStatusController::class, 'index'])->name('get_ticket_statuses');
Route::match(['get', 'post'], '/get_departments', [App\Http\Controllers\DepartmentController::class, 'index'])->name('get_departments');
Route::match(['get', 'post'], '/get_tags', [App\Http\Controllers\TagController::class, 'index'])->name('get_tags');
Route::match(['get', 'post'], '/get_canned_response', [App\Http\Controllers\CannedResponseController::class, 'index'])->name('get_canned_response');
Route::match(['get', 'post'], '/get_staffs', [App\Http\Controllers\StaffController::class, 'index'])->name('get_staffs');
Route::match(['get', 'post'], '/get_settings', [App\Http\Controllers\SettingController::class, 'index'])->name('get_settings');
Route::match(['get', 'post'], '/get_languages', [App\Http\Controllers\LanguageController::class, 'index'])->name('get_languages');
Route::match(['get', 'post'], '/get_faq_category', [App\Http\Controllers\FaqCategoryController::class, 'index'])->name('get_faq_category');
Route::match(['get', 'post'], '/get_faqs', [App\Http\Controllers\FaqController::class, 'index'])->name('get_faqs');
Route::match(['get', 'post'], '/get_kb_category', [App\Http\Controllers\KbCategoryController::class, 'index'])->name('get_kb_category');
Route::match(['get', 'post'], '/get_kb_article', [App\Http\Controllers\KbArticleController::class, 'index'])->name('get_kb_article');
Route::match(['get', 'post'], '/get_users', [App\Http\Controllers\UserController::class, 'index'])->name('get_users');
Route::match(['get', 'post'], '/get_tickets', [App\Http\Controllers\TicketController::class, 'index'])->name('get_tickets');

Route::resource('theme', App\Http\Controllers\ThemeController::class);
Route::resource('ticket', App\Http\Controllers\TicketController::class);
Route::resource('staff', App\Http\Controllers\StaffController::class);
Route::resource('user', App\Http\Controllers\UserController::class);
Route::resource('language', App\Http\Controllers\LanguageController::class);
Route::resource('settings', App\Http\Controllers\SettingController::class);
Route::resource('imap_ticket', App\Http\Controllers\ImapTicketController::class);
Route::match(['get', 'post'],'get_imap_ticket', [App\Http\Controllers\ImapTicketController::class,'index'])->name('get_imap_ticket');
Route::resource('error_log', App\Http\Controllers\ErrorLogController::class);
Route::resource('email_template', App\Http\Controllers\EmailTemplateController::class);
Route::resource('tags', App\Http\Controllers\TagController::class);
Route::resource('faq_category', App\Http\Controllers\FaqCategoryController::class);
Route::resource('faq', App\Http\Controllers\FaqController::class);
Route::resource('kb_category', App\Http\Controllers\KbCategoryController::class);
Route::resource('kb_article', App\Http\Controllers\KbArticleController::class);
Route::resource('articles', App\Http\Controllers\ArticleController::class);
Route::resource('faq_list', App\Http\Controllers\FaqListController::class);
Route::resource('canned_responses', App\Http\Controllers\CannedResponseController::class);
Route::resource('addon', App\Http\Controllers\AddonController::class);

Route::get('/article/{slug}', [App\Http\Controllers\ArticleController::class, 'showArticle'])->name('showArticle');

Route::match(['get', 'post'], '/{uuid}/ticket_reply', [App\Http\Controllers\TicketController::class, 'reply'])
    ->name('ticket.reply');
    Route::match(['get', 'post'], '/{uuid}/ticket_closed', [App\Http\Controllers\TicketController::class, 'closedStatus'])
    ->name('ticket.closed_status');
Route::match(['get', 'post'], '/{uuid}/ticket_modify', [App\Http\Controllers\TicketController::class, 'modify'])
    ->name('ticket.modify');
Route::match(['get', 'post'], '/{uuid}/ticket_note', [App\Http\Controllers\TicketController::class, 'note'])
    ->name('ticket.note');
    Route::match(['get', 'post'], '/{uuid}/ticket_feedback', [App\Http\Controllers\TicketController::class, 'feedback'])
    ->name('ticket.feedback');
    Route::delete('/feedback_delete/{uuid}', [App\Http\Controllers\TicketController::class, 'feedbackDelete'])->name('feedback_delete');
    Route::get('/feedback_edit/{uuid}', [App\Http\Controllers\TicketController::class, 'feedbackEdit'])->name('feedback_edit');

    Route::delete('/article_delete/{uuid}', [App\Http\Controllers\TicketController::class, 'articleDelete'])->name('article_delete');
  


Route::match(['get', 'post'], '/{uuid}/internal_ticket_note', [App\Http\Controllers\TicketController::class, 'internalNote'])
    ->name('ticket.internal_note');
    Route::match(['get', 'post'], '/{uuid}/make_article', [App\Http\Controllers\TicketController::class, 'makeArticle'])
    ->name('ticket.make_article');
    Route::match(['get', 'post'], '/{uuid}/make_article_edit/{article_id}', [App\Http\Controllers\TicketController::class, 'makeArticleEdit'])
    ->name('ticket.make_article_edit');
Route::match(['get', 'post'], '/status_tickets/{id}', [App\Http\Controllers\TicketController::class, 'ticketByStatus'])
    ->name('tickets');
    Route::match(['get', 'post'], '/my_ticket', [App\Http\Controllers\TicketController::class, 'myTicket'])->name('my_ticket');;
Route::get('/assigned_to_me', [App\Http\Controllers\TicketController::class, 'assignedToMe'])->name('ticket_assigned_me');

Route::match(['get', 'post'], '/{uuid}/imap_ticket_reply', [App\Http\Controllers\ImapTicketController::class, 'reply'])
    ->name('imap_ticket.reply');
Route::match(['get', 'post'], '/{uuid}/imap_ticket_modify', [App\Http\Controllers\ImapTicketController::class, 'modify'])
    ->name('imap_ticket.modify');
Route::match(['get', 'post'], '/{uuid}/imap_ticket_note', [App\Http\Controllers\ImapTicketController::class, 'note'])
    ->name('imap_ticket.note');
Route::match(['get', 'post'], '/{uuid}/internal_imap_ticket_note', [App\Http\Controllers\ImapTicketController::class, 'internalNote'])
    ->name('imap_ticket.internal_note');
Route::match(['get', 'post'], '/imap_status_tickets/{id}', [App\Http\Controllers\ImapTicketController::class, 'ticketByStatus'])
    ->name('imapTickets');
Route::get('/email_assigned_to_me', [App\Http\Controllers\ImapTicketController::class, 'assignedToMe'])->name('email_ticket_assigned_me');

Route::get('/download/{file}', [App\Http\Controllers\TicketController::class, 'download'])->name('download');
Route::get('/imap_download/{file}', [App\Http\Controllers\ImapTicketController::class, 'download'])->name('imap_download');

Route::delete('/delete_reply/{uuid}', [App\Http\Controllers\TicketController::class, 'replyDelete'])->name('delete_reply');
Route::delete('/delete_note/{uuid}', [App\Http\Controllers\TicketController::class, 'noteDelete'])->name('delete_note');
Route::delete('/delete_internal_note/{uuid}', [App\Http\Controllers\TicketController::class, 'internalNoteDelete'])->name('delete_internal_note');

Route::delete('/delete_imap_reply/{uuid}', [App\Http\Controllers\ImapTicketController::class, 'replyDelete'])->name('delete_imap_reply');
Route::delete('/delete_imap_note/{uuid}', [App\Http\Controllers\ImapTicketController::class, 'noteDelete'])->name('delete_imap_note');
Route::delete('/delete_imap_internal_note/{uuid}', [App\Http\Controllers\ImapTicketController::class, 'internalNoteDelete'])->name('delete_imap_internal_note');

Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'index'])->name('profile');
Route::post('/profile/update', [App\Http\Controllers\ProfileController::class, 'update'])->name('profileUpdate');
Route::get('/languages', [App\Http\Controllers\LanguageController::class, 'lang'])->name('lang');


Route::get('/privacy_policy', [App\Http\Controllers\FooterController::class, 'privacyPolicy'])->name('privacyPolicy');
Route::get('/terms_of_use', [App\Http\Controllers\FooterController::class, 'terms'])->name('terms');

Route::get('/get_canned_responses_api', [App\Http\Controllers\CannedResponseController::class, 'getCannedResponsesApi'])->name('getCannedResponsesApi');

Route::get('/get_tags_api', [App\Http\Controllers\TagController::class, 'getTagsApi'])->name('getTagsApi');



Route::match(['get', 'post'], '/feedback', [App\Http\Controllers\TicketController::class, 'feedbacks'])
    ->name('feedbacks');

$path = dirname(__FILE__);
foreach(glob($path.'/addons/*.php') as $file) {
    include_once $file;
}