
@extends( 
        ($theme =="white") ? 'layouts.white_theme':
     ( ($theme =="red") ? 'layouts.red_theme':
    (($theme =="green") ? 'layouts.green_theme':
    (($theme =="black") ? 'layouts.black_theme':
   ( ($theme =="blue") ?'layouts.blue_theme': 'layouts.yellow_theme' ))))
    )

@section('content')

<div class="section-header shadow-none">
  <h1>{{ __(' Add Add-on') }}</h1>
  <div class="section-header-breadcrumb">
        <div class="breadcrumb-item active"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></div>
        <div class="breadcrumb-item"><a href="{{ route('addon.index') }}">{{ __('Add-on') }}</a>
        </div>
        <div class="breadcrumb-item">{{ __('Add Add-on') }}</div>
    </div>
</div>


  <div class="row">
    <div class="col-12">
      @include('common.demo')
    
      @include('common.errors')
      <div class="card">
        @if (env('APP_ENV') == 'demo')
            <div class="alert alert-warning demo-alert text-center" role="alert">
            <strong>{{ __('Note: ') }}</strong>  In Demo, addon install is disbaled.
            </div>
        @else
            <div class="card-body">
                <form method="POST" action="{{ route('addon.store') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row mb-4">
                        <label
                            class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Upload File') }}:*</label>
                        <div class="col-sm-12 col-md-7">
                            <input id="addonfile" type="file"
                                class="form-control box_file @error('addonfile') is-invalid @enderror"
                                name="addonfile" value="{{ old('addonfile') }}"
                                autocomplete="addonfile" autofocus >

                            @error('addonfile')
                            <div class="text-danger pt-1">{{ $message }}</div>
                            @enderror

                            <small id="help1" class="form-text text-muted">
                                {{ __('Add the zip folder here') }}
                            </small>
                        </div>
                    </div>
                    <div class="form-group row mb-4">
                        <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                        <div class="col-sm-12 col-md-7">
                            <button type="submit" class="btn btn-custom">{{ __('Upload') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        @endif
      </div>
    </div>
  </div>
</div>
@endsection
