@extends( 
        ($theme =="white") ? 'layouts.white_theme':
     ( ($theme =="red") ? 'layouts.red_theme':
    (($theme =="green") ? 'layouts.green_theme':
    (($theme =="black") ? 'layouts.black_theme':
   ( ($theme =="blue") ?'layouts.blue_theme': 'layouts.yellow_theme' ))))
    )

@section('content')

<div class="section-header">
  <h1>{{ __('Add-on') }}</h1>
  <div class="section-header-breadcrumb">
        <div class="breadcrumb-item active"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></div>
        <div class="breadcrumb-item"><a href="{{ route('addon.index') }}">{{ __('Add-on') }}</a>
        </div>
        <div class="breadcrumb-item">{{ __('Twilio SMS Settings') }}</div>
    </div>
</div>

<div class="section-body">
  <h2 class="section-title">{{ __('Twilio SMS Settings') }}</h2>
  <p class="section-lead">
  </p>

  <div class="row">
    <div class="col-12">
      @include('common.demo')
     
      @include('common.errors')
      <div class="card">
        <div class="card-header">
          <h4 class="d-sm-inline-block">{{ __('Twilio SMS Settings') }}</h4>
        </div>
        <div class="card-body">
                    <form method="POST" action="{{ route('storeSettings') }}">
                        @csrf


                        <div class="form-group row mb-4">
                            <label
                                class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Twilio SID') }}:*</label>
                            <div class="col-sm-12 col-md-7">
                                <input id="sid" type="text"
                                    class="form-control  @error('sid') is-invalid @enderror"
                                    name="sid" value="{{ old('sid', $settings != null ? $settings['sid'] : '') }}"
                                    autocomplete="sid" autofocus >

                                @error('sid')
                                <div class="text-danger pt-1">{{ $message }}</div>
                                @enderror

                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label
                                class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Twilio Auth Token') }}:*</label>
                            <div class="col-sm-12 col-md-7">
                                <input id="token" type="password"
                                    class="form-control  @error('token') is-invalid @enderror"
                                    name="token" value="{{ old('token', $settings != null ? $settings['auth_token'] : '') }}"
                                    autocomplete="token" autofocus >

                                @error('token')
                                <div class="text-danger pt-1">{{ $message }}</div>
                                @enderror

                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label
                                class="col-form-label text-md-right col-12 col-md-3 col-lg-3">{{ __('Twilio Number') }}:*</label>
                            <div class="col-sm-12 col-md-7">
                                <input id="number" type="tel"
                                    class="form-control box_file @error('number') is-invalid @enderror"
                                    name="number" value="{{ old('number', $settings != null ? $settings['number'] : '') }}"
                                    autocomplete="number" autofocus >

                                @error('number')
                                <div class="text-danger pt-1">{{ $message }}</div>
                                @enderror

                            </div>
                        </div>
                        <div class="form-group row mb-4">
                            <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7">
                                <button type="submit" class="btn btn-custom">{{ __('Save') }}</button>
                            </div>
                        </div>
                    </form>

          
        </div>
      </div>
    </div>
  </div>
</div>
@endsection