@extends( 
        ($theme =="white") ? 'layouts.public_white':
     ( ($theme =="red") ? 'layouts.public_red':
    (($theme =="green") ? 'layouts.public_green':
    (($theme =="black") ? 'layouts.public_black':
    (($theme =="blue") ?'layouts.public_blue':'layouts.public_yellow' ))))
    )

@section('content')
    <div class="row px-3">
        <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-6 offset-xl-3">
            {{-- <div class="login-brand">
                <img src="assets/img/stisla-fill.svg" alt="logo" width="100" class="shadow-light rounded-circle">
            </div> --}}

            <div class="card card-custom">
                <div class="card-header">
                    <h2 class="text-center">Sign in</h2>
                    <!-- <h4 class="inline-block">{{ isset($url) ? ucwords($url) : '' }} {{ __('Login') }}</h4>
                    <a href="{{ route('register') }}"
                        class="btn btn-icon btn-outline-custom bg-transparent float-right inline-block">{{ __('Register') }}
                        <i class="fas fa-arrow-circle-right"></i></a> -->
                </div>

                <div class="card-body">
                    <form method="POST" action="{{route('login')}}">
                        @csrf
                        <div class="form-group">
                            <label for="email">{{ __('E-Mail Address') }}</label>
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror"
                                name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                            @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <div class="d-block">
                                <label for="password" class="control-label">{{ __('Password') }}</label>
                                @if (Route::has('password.request'))
                                <div class="float-right">
                                    <a href="{{ route('password.request') }}" class="fs-5">
                                        {{ __('Forgot Your Password?') }}
                                    </a>
                                </div>
                                @endif
                            </div>
                            <input id="password" type="password"
                                class="form-control @error('password') is-invalid @enderror" name="password" required
                                autocomplete="current-password">

                            @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>

                        <!-- <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input class="custom-control-input" type="checkbox" name="remember" id="remember"
                                    {{ old('remember') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="remember">{{ __('Remember Me') }}</label>

                                @if (Route::has('password.request'))
                                <div class="float-right">
                                    <a href="{{ route('password.request') }}" class="text-small">
                                        {{ __('Forgot Your Password?') }}
                                    </a>
                                </div>
                                @endif
                            </div>
                        </div> -->

                        <div class="form-group">
                            <button type="submit" class="btn btn-custom btn-lg btn-block font-weight-bold" tabindex="4">
                                {{ __('Sign in') }}
                            </button>
                        </div>
                        <div class="text-dark text-right font-weight-bold mt-n2">
                {{ __('Dont have an account') }}? <a href="{{ route('register') }}">{{ __('Create One') }}</a>
            </div>
                        
                    </form>

                </div>
                
            </div>
            <!-- <div class="mt-5 text-dark text-center">
                {{ __('Dont have an account') }}? <a href="{{ route('register') }}">{{ __('Create One') }}</a>
            </div> -->
        </div>
    </div>
</div>

@endsection