@extends( 
        ($theme =="white") ? 'layouts.public_white':
     ( ($theme =="red") ? 'layouts.public_red':
    (($theme =="green") ? 'layouts.public_green':
    (($theme =="black") ? 'layouts.public_black':
    (($theme =="blue") ?'layouts.public_blue':'layouts.public_yellow' ))))
    )

@section('content')
<div class="s004">
<form  class="home_form" method="POST" action="/">
 @csrf
 <div class="form-group">
<fieldset>
<legend>What are you looking for?</legend>


<div class="inner-form">
<div class="input-field">
<div class="choices" data-type="text" aria-haspopup="true" aria-expanded="false" dir="ltr">
          <div class="choices__inner">
          <input id="article" type="text" placeholder="What are you looking for?"
          class="form-control choices__input is-hidden on-focus:border-0" name="article"
                                        value="{{ old('article') }}" autocomplete="article" autofocus>
          </div>
           <div class="choices__list choices__list--dropdown" aria-expanded="false">
          </div>
        </div>
<button class="btn-search" type="submit">
<svg xmlns="http://www.w3.org/2000/svg" width="45" height="45" fill="#fff" viewBox="0 0 24 24">
<path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path>
</svg>
</button>
</div>
</div>


</fieldset>

@if(count($articles))


    <h4 class="search_results_title mb-4 text-center">{{count($articles)}} Search Results Found</h4>

    <div class="container mb-5">
      <div class="row">
       
        @foreach($articles as $article)
        <div class=" d-flex  col-lg-6 col-12 col-md-6 mb-4">
<div class="wizard-step-label home-article result_box">
<a class="nav-link "
    href="{{ route('showArticle', [$article->slug]) }}">
        {{ __($article->title) }} </a>
        <p> {!!Str::limit(strip_tags($article->description),  60) !!}.</p>
</div>
</div>
@endforeach




</div>
</div>


@endif

<!-- Section_1 -->
<section>
  <div class="container">
    <div class="row flex-nowrap">
      <!-- Card_1 -->
<div class="card mb-3" style="max-width: 540px;">
  <div class="row g-0">
    <div class="col-md-4 d-flex justify-content-center align-items-center">
      <!-- <img src="..." class="img-fluid rounded-start" alt="..."> -->
      <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" fill="#C0C0C0" class="bi bi-envelope-paper" viewBox="0 0 16 16">
  <path d="M4 0a2 2 0 0 0-2 2v1.133l-.941.502A2 2 0 0 0 0 5.4V14a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V5.4a2 2 0 0 0-1.059-1.765L14 3.133V2a2 2 0 0 0-2-2H4Zm10 4.267.47.25A1 1 0 0 1 15 5.4v.817l-1 .6v-2.55Zm-1 3.15-3.75 2.25L8 8.917l-1.25.75L3 7.417V2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v5.417Zm-11-.6-1-.6V5.4a1 1 0 0 1 .53-.882L2 4.267v2.55Zm13 .566v5.734l-4.778-2.867L15 7.383Zm-.035 6.88A1 1 0 0 1 14 15H2a1 1 0 0 1-.965-.738L8 10.083l6.965 4.18ZM1 13.116V7.383l4.778 2.867L1 13.117Z"/>
</svg>
    </div>
    <div class="col-md-8">
      <div class="card-body">
        <h5 class="card-title"><a class="home-article" href="{{ route('articles.index') }}">{{ __('Knowledge Base') }}</a></h5>
        <p class="card-text "> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
      </div>
    </div>
  </div>
</div>
<!-- End -->

<!-- Card_2 -->
<div class="card mb-3" style="max-width: 540px;">
  <div class="row g-0">
    <div class="col-md-4 d-flex justify-content-center align-items-center">
      <!-- <img src="..." class="img-fluid rounded-start" alt="..."> -->
      <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" fill="#C0C0C0" class="bi bi-binoculars" viewBox="0 0 16 16">
  <path d="M3 2.5A1.5 1.5 0 0 1 4.5 1h1A1.5 1.5 0 0 1 7 2.5V5h2V2.5A1.5 1.5 0 0 1 10.5 1h1A1.5 1.5 0 0 1 13 2.5v2.382a.5.5 0 0 0 .276.447l.895.447A1.5 1.5 0 0 1 15 7.118V14.5a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 14.5v-3a.5.5 0 0 1 .146-.354l.854-.853V9.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5v.793l.854.853A.5.5 0 0 1 7 11.5v3A1.5 1.5 0 0 1 5.5 16h-3A1.5 1.5 0 0 1 1 14.5V7.118a1.5 1.5 0 0 1 .83-1.342l.894-.447A.5.5 0 0 0 3 4.882V2.5zM4.5 2a.5.5 0 0 0-.5.5V3h2v-.5a.5.5 0 0 0-.5-.5h-1zM6 4H4v.882a1.5 1.5 0 0 1-.83 1.342l-.894.447A.5.5 0 0 0 2 7.118V13h4v-1.293l-.854-.853A.5.5 0 0 1 5 10.5v-1A1.5 1.5 0 0 1 6.5 8h3A1.5 1.5 0 0 1 11 9.5v1a.5.5 0 0 1-.146.354l-.854.853V13h4V7.118a.5.5 0 0 0-.276-.447l-.895-.447A1.5 1.5 0 0 1 12 4.882V4h-2v1.5a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5V4zm4-1h2v-.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5V3zm4 11h-4v.5a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5V14zm-8 0H2v.5a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5V14z"/>
</svg>
    </div>
    <div class="col-md-8">
      <div class="card-body">
        <h5 class="card-title"><a class="home-article" href="{{ route('faq_list.index') }}">{{ __('FAQs') }}</a></h5>
        <p class="card-text"> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>
      </div>
    </div>
  </div>
</div>
<!-- End -->
    </div>
  </div>

  <div class="container">
    <div class="row flex-nowrap">
      <!-- Card_1 -->
<div class="card mb-3" style="max-width: 540px;">
  <div class="row g-0 ">
    <div class="col-md-4 d-flex justify-content-center align-items-center">
      <!-- <img src="..." class="img-fluid rounded-start" alt="..."> -->
      <svg xmlns="http://www.w3.org/2000/svg" width="200" height="50" fill="#C0C0C0" class="bi bi-calendar2-check" viewBox="0 0 16 16">
  <path d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
  <path d="M3.5 0a.5.5 0 0 1 .5.5V1h8V.5a.5.5 0 0 1 1 0V1h1a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V3a2 2 0 0 1 2-2h1V.5a.5.5 0 0 1 .5-.5zM2 2a1 1 0 0 0-1 1v11a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H2z"/>
  <path d="M2.5 4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5H3a.5.5 0 0 1-.5-.5V4z"/>
</svg>
    </div>
    <div class="col-md-8 ">
      <div class="card-body">
      @if (Auth::check() && Auth::user()->role == 'user')
        <h5 class="card-title "><a class="home-article"  href="{{ route('get_tickets') }}"> {{ __('Tickets') }}</a></h5>
          <p class="card-text "> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>
        </div>
      </div>
    </div>
  </div>
        @else 
          <h5 class="card-title"><a class="home-article"  href="{{ route('login') }}"> {{ __('Login') }}</a></h5>
            <p class="card-text"> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>
            </div>
          </div>
        </div>
      </div>
      @endif
   
<!-- End -->

<!-- Card_2 -->
<div class="card mb-3" style="max-width: 540px;">
  <div class="row g-0">
    <div class="col-md-4 d-flex justify-content-center align-items-center">
      <!-- <img src="..." class="img-fluid rounded-start" alt="..."> -->
      <svg xmlns="http://www.w3.org/2000/svg" width="100" height="50" fill="#C0C0C0" class="bi bi-bookmarks" viewBox="0 0 16 16">
  <path d="M2 4a2 2 0 0 1 2-2h6a2 2 0 0 1 2 2v11.5a.5.5 0 0 1-.777.416L7 13.101l-4.223 2.815A.5.5 0 0 1 2 15.5V4zm2-1a1 1 0 0 0-1 1v10.566l3.723-2.482a.5.5 0 0 1 .554 0L11 14.566V4a1 1 0 0 0-1-1H4z"/>
  <path d="M4.268 1H12a1 1 0 0 1 1 1v11.768l.223.148A.5.5 0 0 0 14 13.5V2a2 2 0 0 0-2-2H6a2 2 0 0 0-1.732 1z"/>
</svg>
    </div>
    <div class="col-md-8">
      <div class="card-body">
      <h5 class="card-title"><a class="home-article" href="{{ route('user_announcements') }}">{{ __('Announcements') }}</a></h5>
        <p class="card-text"> Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est </p>
      </div>
    </div>
  </div>
</div>
<!-- End -->
    </div>
  </div>
</section>
<!-- Section_1 End -->

</div>
</form>



</div>


@endsection